﻿    <%@page contentType="text/html;charset=utf-8"%>
	<!DOCTYPE html>
	<html>
	<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<meta http-equiv="Content-Script-Type" content="text/javascript" />
	<meta http-equiv="Content-Style-Type" content="text/css" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<link rel="stylesheet" href="http://code.jquery.com/ui/1.10.3/themes/smoothness/jquery-ui.css" />
	<link rel=stylesheet href="lib/codemirror.css">
	<script src="lib/codemirror.js"></script>
	<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery.min.js"></script>
	<script  type="text/javascript" src="http://code.jquery.com/ui/1.10.3/jquery-ui.js"></script>
	<script type="text/javascript" src="../js/common.js"></script>
	<script type="text/javascript" src="../Chart/highcharts/highcharts.js"></script>
	<script type="text/javascript" src="../Chart/ibchart.js"></script>
	<script type="text/javascript" src="../Chart/ibchartinfo.js"></script>
	<title>IBSheet7-Product</title>

	<style>
	.controlFieldSet {
		padding: 1em;
		font:1.1em sans-serif;
		border:1px solid #9cb6cf
	}
	.fieldSetTitle {
		padding: 5px;
		border:1px solid #9cb6cf;
		color:#565656;
		font-size:100%;
		text-align:left;
		font-weight:700;
		font-size:12pt;
	}
	.fieldSetTitle:hover{
		background-color:#ADADAD;
		cursor:pointer;
	}

	.ulTable{display:table}
	.liRow{display: table-row;float:left;padding:0 0 5px 0;line-height:26px}
	.liCellTitle{
		display: table-cell;font-weight:700;padding:0 1px 0 5px;
		font-family:dotum, Malgun Gothic, Arial, Helvetica, sans-serif;
		font-size:12px;
		list-style-type:circle;
		width:200px;
		vertical-align:top;
	}
	.liCellContent{
		display: table-cell;padding:0 5px 0 1px;
		font-family:dotum, Malgun Gothic, Arial, Helvetica, sans-serif;
		font-size:12px;
		list-style-type:none;
		width:200px;
	}
	.liCellContent_w{
		display: table-cell;padding:0 5px 0 1px;
		font-family:dotum, Malgun Gothic, Arial, Helvetica, sans-serif;
		font-size:12px;
		list-style-type:none;
	}
	</style>

	<script language="javascript">
		AutoResizeOff = true;

		String.prototype.trim = function() {
			return this.replace(/(^\s*)|(\s*$)/gi, "");
		}

		$(document).ready(function() {
			$(".fieldSetTitle").click(function() {
				$(this).parent().children(".ulTable").toggle();
			});

//			resizeWork();
//			$(window).resize(resizeWork);
//			$("#main_DIV").resize(resizeWork);
			createIBChart(myChart, "myChart", {
				width: "100%",
				height: "300px"
			});
		})

		function resizeWork(){
			$("#main_DIV").height($(window).height() - 150);
		}

		/*Chart 각종 처리*/
		function doAction(sAction) {
			switch (sAction) {
				case "show": //chart 생성
				var chartOption = inputMake();
				
				if( chartOption["xAxis"]["labels"] && chartOption["xAxis"]["labels"]["formatter"]){
						var str = chartOption["xAxis"]["labels"]["formatter"];
						chartOption["xAxis"]["labels"]["formatter"] = eval("("+str.substring(1,str.length-1) +")");
				}
				if( chartOption["yAxis"][0]["labels"] && chartOption["yAxis"][0]["labels"]["formatter"]){
						var str = chartOption["yAxis"][0]["labels"]["formatter"];
						chartOption["yAxis"][0]["labels"]["formatter"] = eval("("+str.substring(1,str.length-1) +")");
				}
				
				
				if( chartOption["tooltip"]["formatter"]){
						var str = chartOption["tooltip"]["formatter"];
						chartOption["tooltip"]["formatter"] = eval("("+str.substring(1,str.length-1) +")");
				}
				
				myChart.setOptions(chartOption);
				myChart.doSearch("chartdata01.xml",{
					append: true
				});
				break;
				case "make":
				var chartOption = inputMake();
				var jsonStr = JSON.stringify(chartOption, function(key, val) {
					if (typeof val === 'function') {
						return val + '';
					}
					return val;
				}, 4);

				jsonStr = jsonStr.split("\\r").join("\r");
				jsonStr = jsonStr.split("\\n").join("\n");
				jsonStr = jsonStr.split("\\\"").join("\"");
				jsonStr = jsonStr.split("\"‡").join("");
				jsonStr = jsonStr.split("‡\"").join("");

				jsonStr = "var prop ="+jsonStr;
				jsonStr = jsonStr +"\nmyChart.setOptions(prop);";
				//코드 생성 dialog 초기 값 설정
				var h  = $(window).height()-200;
				$( "#dialog" ).dialog({ width: 700,height:h,beforeClose: function( event, ui ) {
			  			$(".CodeMirror").remove();
			  		} });

				//code highlighter 생성
				var editor = CodeMirror.fromTextArea(document.getElementById("gcodetxt"), {
					lineNumbers: true,
					lineWrapping:true,
					mode: "javascript",
					matchBrackets: true
				});
				editor.setValue(jsonStr);

				$( "#dialog" ).show();
				break;
			}
		}

		function inputMake() {
			var chartOption = {};
			chartOption["chart"] = {};

			if ($("#title").val() !== "") {
				//타이틀 생성
				var title = {};
				//타이틀 내용
				title["text"] = $("#title").val();

				//타이틀 가로 정렬
				if ($("#titleAlign").val() !== "") {
					title["align"] = $("#titleAlign").val();
				}
				//타이틀 세로 정렬
				if ($("#titleVerticalAlign").val() !== "") {
					title["verticalAlign"] = $("#titleVerticalAlign").val();
				}
				//X 방향 미세조정
				if ($("#XpxTitle").val() !== "") {
					title["x"] = ~~($("#XpxTitle").val());
				}
				//Y 방행 미세조정
				if ($("#YpxTitle").val() !== "") {
					title["y"] = ~~($("#YpxTitle").val());
				}
//				title["floating"] = true;
				chartOption["title"] = title;
			}

				//부 제목 설정
			if ($("#subtitle").val() !== "") {
				chartOption["subtitle"] = {};
				chartOption["subtitle"]["text"] = $("#subtitle").val();
			}

			//==========================범례 사용=====================================
			var legend = {};
			if ($("#LegendEnabled").is(":checked") == true) {
				legend["enabled"] = true;
				//범례 타이틀
				if ($("#LegendTitle").val() != "") {
					legend["title"] = {};
					legend["title"]["text"] = $("#LegendTitle").val();
					legend["title"]["align"] = "center";
				}

				//범례 위치
				legend["layout"] = $("#LegendLayout").val();
				legend["align"] = $("#LegendAlign").val();
				legend["verticalAlign"] = $("#LegendVerticalAlign").val();

				//범례역순
				legend["reversed"] = $("#LegendReversed").is(":checked");
				//범례 테두리
				if ($("#LegendBorderWidth").val() != "") legend["borderWidth"] = $("#LegendBorderWidth").val();
				if ($("#LegendBorderColor").val() != "") legend["borderColor"] = $("#LegendBorderColor").val();
				if ($("#LegendRadius").val() != "") legend["borderRadius"] = $("#LegendRadius").val();

				//범례 플로팅 여부
				legend["floating"] = $("#LegendFloating").is(":checked");
			} else {
				legend["enabled"] = false;
			}
			chartOption["legend"] = legend;

			//================== X 축 설정 ===========================
			var xAxis = {};

			//X축 타이틀 설정
			if ($("#Xtitle").val() !== "") {
				xAxis["title"] = {};
				xAxis["title"]["text"] =  $("#Xtitle").val();

				if ($("#XTitleRotation").val() != "") {
					xAxis["Title"]["rotation"] =  ~~($("#XTitleRotation").val());
				}
			} else {

				xAxis["Title"] = {};
				xAxis["Title"]["enabled"] = false;

			}

			//X축 선 굵기,색상 설정
			if ($("#XLineWidth").val() != "") {
				xAxis["lineWidth"] = ~~($("#XLineWidth").val());

			if ($("#XLineColor").val() != "") {
				xAxis["lineColor"] = $("#XLineColor").val();
			}}


			//X축 내부 선 굵기,색상,모양 설정
			if ($("#XGridLineWidth").val() != "") {
				xAxis["gridLineWidth"] = ~~($("#XGridLineWidth").val());
			}
			if ($("#XGridLineColor").val() != "") {
				xAxis["gridLineColor"] = $("#XGridLineColor").val();
			}
			if ($("#XGridLineDashStyle").val() != "") {
				xAxis["gridLineDashStyle"] = $("#XGridLineDashStyle").val();
			}


			//X축 레이블 설정
			xAxis["labels"] = {};
			if ($("#XLabels").is(":checked")) { //레이블 사용
				xAxis["labels"]["enabled"]= true;
				//레이블 정렬
				xAxis["labels"]["align"] = $("#XLabelsAlign").val();
				//레이블 다단 사용
				if ($("#XStaggerLines").val() != "") {
					xAxis["labels"]["staggerLines"] = ~~($("#XStaggerLines").val());
				}
				//레이블 회전
				if ($("#XLabelsRotation").val() != "") {
						xAxis["labels"]["rotation"] = ~~($("#XLabelsRotation").val());
				}
				//레이블 간격
				if ($("#XLabelsInterval").val() != "") {
						xAxis["tickInterval"] = ~~($("#XLabelsInterval").val());
				}
				//레이블 포멧터
				if ($("#XLabelsFormatter").val() != "") {
					var formatterStr = $("#XLabelsFormatter").val();
					formatterStr = "            "+formatterStr.split("\n").join("\r\n                 ");
					xAxis["labels"]["formatter"]  = "‡function(){\r\n"+ formatterStr+"\r\n        }‡";
				}

			} else {//레이블 사용 안함.
				xAxis["labels"]["enabled"]= false;
			}
			chartOption["xAxis"] = xAxis;

			//================== Y 축 설정 ===========================
			var yAxis = {};

			//Y축 타이틀
			if ($("#Ytitle").val() != "") {
				yAxis["title"] = {};
				yAxis["title"]["text"] = $("#Ytitle").val();
				if ($("#YTitleRotation").val() != null) { //타이틀 회전
					yAxis["title"]["rotation"] = ~~($("#YTitleRotation").val());
				}
			}else{
				yAxis["title"] = {};
				yAxis["title"]["enabled"] = false;
			}

			//Y축 선 설정
			if ($("#YLineWidth").val() != "") { //굵기
				yAxis["lineWidth"] = ~~($("#YLineWidth").val());
			}
			if ($("#YLineColor").val() != "") { //색상
				yAxis["lineColor"] = $("#YLineColor").val();
			}

			//Y축 내부선 설정
			if ($("#YGridLineWidth").val() != "") {//선의 굵기
				yAxis["gridLineWidth"] = ~~($("#YGridLineWidth").val());
			}

			if ($("#YGridLineColor").val() != "") {//선의 색상
				yAxis["gridLineColor"] = $("#YGridLineColor").val();
			}

			yAxis["gridLineDashStyle"] = $("#YGridLineDashStyle").val();//선의 스타일

			yAxis["labels"] = {};
			if ($("#YLabels").is(":checked")) {
				yAxis["labels"]["enabled"] = true;//축레이블 사용 여부
				if ($("#YLabelsRotation").val() !== "") { //축레이블 회전
					yAxis["labels"]["rotation"] =  ~~($("#YLabelsRotation").val());
				}
				if ($("#YTickInterval").val() !== "") {//축 레이블 간격
					yAxis["tickInterval"] = ~~($("#YTickInterval").val())
				}
				//레이블 포멧터
				if ($("#YLabelsFormatter").val() != "") {
					var formatterStr = $("#YLabelsFormatter").val();
					formatterStr = "            "+formatterStr.split("\n").join("\r\n                 ");
					yAxis["labels"]["formatter"]  = "‡function(){\r\n"+ formatterStr+"\r\n        }‡";
				}

				//최대 최소값
				if ($("#YMax").val() != "") {
					yAxis["max"] =  ~~($("#YMax").val() );
				}
				if ($("#YMin").val() != "") {
					yAxis["min"] =  ~~($("#YMin").val() );
				}

			} else {
				yAxis["labels"]["enabled"] = false;

			}

			chartOption["yAxis"] = [yAxis];

			if ($("#YSecond").is(":checked")) {
				var y2axis = {};
				y2axis["opposite"] = true;
				y2axis["title"] = {};
				y2axis["title"]["text"] = "Second Y축";
				chartOption["yAxis"].push(y2axis);
			}

			//========================== 툴팁 설정 ========================================
			var tooltip = {};
			if ($("#tooltipEnabled").is(":checked")) {
				tooltip["enabled"] =  true;

				//레이블 포멧터
				if ($("#tooltipFormatter").val() != "") {
					var formatterStr = $("#tooltipFormatter").val();
					formatterStr = "            "+formatterStr.split("\n").join("\r\n                 ");
					tooltip["formatter"]  = "‡function(){\r\n"+ formatterStr+"\r\n        }‡";
				}

				if ($("#tooltipBorderWidth").val() != null) {
					tooltip["borderWidth"] =  ~~($("#tooltipBorderWidth").val());
				}

				if ($("#tooltipShared").is(":checked")) {
					tooltip["shared"] = true;
				}

			} else {
				tooltip["enabled"] =  false;
			}
			chartOption["tooltip"] = tooltip;

			//========================== 기타 설정 ==========================================
			var plot = {};
			plot["series"] = {};
			plot["series"]["dataLabels"] = {};
			if ($("#DataLabel").is(":checked")) {
				plot["series"]["dataLabels"]["enabled"] = true;
				plot["series"]["dataLabels"]["align"] = $("#DataLabelAlign").val();
			}else{
				plot["series"]["dataLabels"]["enabled"] = false;
			}

			//애니메이션 기능 사용
			if($("#animation").is(":checked")) {
				plot["series"]["animation"] = true;
			}else{
				plot["series"]["animation"] = false;
			}
			chartOption["plotOptions"] = plot;


			//확대 기능 사용
			if ($("#useZoom").val() != "") {
				chartOption["chart"]["zoomType"] = 	$("#useZoom").val();
			}



			var colorEle = document.getElementsByName("SeriesColor");
			var colors = [];
			for(var i=0;i<colorEle.length;i++){
				if(colorEle[i].value!=""){
					colors.push(colorEle[i].value);
				}
			}
			if(colors.length>0){
				chartOption["colors"] = colors;
			}

			//========================== 차트 유형 설정 ==========================================

			switch ($("#charttype").val()) {
				case "line":

					break;
				case "area":

						break;
				case "spline":

					break;
				case "scatter":

					break;
				case "column":
					cType =  "column";
					if ($("#ColorByPoint").is(":checked")) {
						chartOption["plotOptions"]["column"] = {};
						chartOption["plotOptions"]["column"][ "colorByPoint"] = true;
					}

					break;
				case "bar":
					cType =  "bar";
					if ($("#ColorByPoint").is(":checked")) {
						chartOption["plotOptions"]["bar"] = {};
						chartOption["plotOptions"]["bar"][ "colorByPoint"] = true;
					}
					break;
				case "pie":
					cType =  "pie";
					if($("#LegendEnabled").is(":checked") ){
						chartOption["plotOptions"]["pie"] = {};
						chartOption["plotOptions"]["pie"]["showInLegend"] =  true;
					}
						break;
			}
			chartOption["chart"]["type"] = $("#charttype").val();
			return chartOption;
		}
	</script>
	<style>
		.CodeMirror {height:100%; border: 1px solid #ddd; }
		.CodeMirror pre { padding-left: 7px; line-height: 1.25; }
	</style>
</head>
<body  style="height:100%;overflow:hidden">
	<div class="page_title">
		<span>
			<a class="closeDepth" href="#">closeDepth</a>
		</span>
		<span class="title">위자드 >
			<b>차트생성</b>
		</span>
	</div>
	<div id="main_DIV" class="main_content" style="height:calc(100% - 100px);overflow:auto">
		<div class="clear hidden"></div>
		<!-- SetConfig 영역 -->
		<fieldset class="controlFieldSet">
			<legend class="fieldSetTitle">
	        타이틀 설정
	    </legend>
	    <ul id="ulTitle"class="ulTable" style="display:none">
	    	<li class="liRow">
	    		<ul>
	    			<li class="liRow">
	    				<ul>
	    					<li class="liCellTitle" title="메인 타이틀" >메인 타이틀 설정 : </li>
	    					<li class="liCellContent">
	    						<input type="textarea" id="title" value="" size="30" class="inputbox" placeHolder="메인 타이틀을 입력하세요."/>
	    					</li>
	    				</ul>
	    				<ul>
	    					<li class="liCellTitle" title="메인 타이틀 가로 정렬">메인 타이틀 가로 정렬 : </li>
	    					<li class="liCellContent">
	    						<select id="titleAlign" class="selectbox" style="width:150px;">
	    							<option value="center" selected>center</option>
	    							<option value="left">left</option>
	    							<option value="right">right</option>
	    						</select>
	    					</li>
	    				</ul>
	    				<ul>
	    					<li class="liCellTitle" title="메인 타이틀 세로 정렬">메인 타이틀 세로 정렬 : </li>
	    					<li class="liCellContent">
	    						<select id="titleVerticalAlign" class="selectbox" style="width:150px;">
	    							<option value="top" selected>top</option>
	    							<option value="middle">middle</option>
	    							<option value="bottom">bottom</option>
	    						</select>
	    					</li>
	    				</ul>
	    				<ul>
	    					<li class="liCellTitle" title="메인 타이틀 X 위치">메인 타이틀 위치 세부 조정(X) : </li>
	    					<li class="liCellContent">
	    						<input type="text" id="XpxTitle" value="" size="10" class="inputbox" placeHolder="숫자입력"/>
	    					</li>
	    				</ul>
	    				<ul>
	    					<li class="liCellTitle" title="메인 타이틀 Y 위치">메인 타이틀 위치 세부 조정(Y) : </li>
	    					<li class="liCellContent">
	    						<input type="text" id="YpxTitle" value="" size="10" class="inputbox" placeHolder="숫자입력"/>
	    					</li>
	    				</ul>
	    				<ul>
	    					<li class="liCellTitle" title="서브 타이틀">서브 타이틀 설정 : </li>
	    					<li class="liCellContent">
	    						<input type="textarea" id="subtitle" value="" size="30" class="inputbox" placeHolder="서브 타이틀을 입력하세요."/>
	    					</li>
	    				</ul>
	    			</li>
	    		</ul>
	    	</li>
	    </ul>
	</fieldset>
	<div style="height:5px"></div>
	<fieldset class="controlFieldSet">
		<legend class="fieldSetTitle">
			축 설정
		</legend>
		<ul id="ulX" class="ulTable" style="display:none">
			<div style="float: left; width: 400px; padding:10px;">
				<span class="subTitle">X축 설정</span>
				<ul class="ulTable" >
					<li class="liRow">
						<ul>
							<li class="liCellTitle" title="X축 타이틀">X 축 타이틀 설정 : </li>
							<li class="liCellContent">
								<input type="textarea" id="Xtitle" value="" size="30" class="inputbox" placeHolder="X축 타이틀을 입력하세요."/>
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="X축 타이틀">X 축 타이틀 회전 : </li>
							<li class="liCellContent">
								<input type="textarea" id="XTitleRotation" value="" size="10" class="inputbox" placeHolder="MAX:360"/> °
							</li>
						</ul>
						<ul style="height:10px"></ul>
						<ul>
							<li class="liCellTitle" title="X축 선의 굵기">선의 굵기 : </li>
							<li class="liCellContent">
								<input type="textarea" id="XLineWidth" value="" size="10" class="inputbox" placeHolder="숫자입력"/> px
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="X축 선의 굵기">선의 색상 : </li>
							<li class="liCellContent">
								<input type="textarea" id="XLineColor" value="" size="10" class="inputbox" placeHolder="#000000"/>
							</li>
						</ul>
						<ul style="height:10px"></ul>
						<ul>
							<li class="liCellTitle" title="X축 내부 선 굵기">내부 선 굵기 : </li>
							<li class="liCellContent">
								<input type="textarea" id="XGridLineWidth" value="" size="10" class="inputbox" placeHolder="숫자입력"/> px
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="X축 내부 선 색상">내부 선 색상 : </li>
							<li class="liCellContent">
								<input type="textarea" id="XGridLineColor" value="" size="10" class="inputbox" placeHolder="#DEDEDE"/>
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="X축 내부 선 모양">내부 선 모양 : </li>
							<li class="liCellContent">
								<select id="XGridLineDashStyle" class="selectbox" style="width:150px;">
									<option value="solid" selected>Solid</option>
									<option value="shortdash">ShortDash</option>
									<option value="dot">Dot</option>
								</select>
							</li>
						</ul>
						<ul style="height:10px"></ul>

						<ul>
							<li class="liCellTitle" title="X축 레이블 사용 여부">레이블 사용 여부 </li>
							<li class="liCellContent">
								<input class="checkbox" type="checkbox" checked id="XLabels" />
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="X축 레이블 정렬">레이블 정렬 : </li>
							<li class="liCellContent">
								<select id="XLabelsAlign" class="selectbox" style="width:150px;">
									<option value="center" selected>center</option>
									<option value="left">left</option>
									<option value="right">right</option>
								</select>
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="X축 레이블 다단">레이블 다단: </li>
							<li class="liCellContent">
								<input type="text" id="XStaggerLines" value="" size="10" class="inputbox" placeHolder="숫자입력"/>
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="X축 레이블 회전">레이블 회전 : </li>
							<li class="liCellContent">
								<input type="text" id="XLabelsRotation" value="" size="10" class="inputbox" placeHolder="MAX:360"/> °
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="X축 레이블 간격">레이블 간격 : </li>
							<li class="liCellContent">
								<input type="text" id="XLabelsInterval" value="" size="10" class="inputbox" placeHolder="숫자입력"/>
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="X축 레이블 포멧">레이블 포멧 설정 : </li>
							<li class="liCellContent">
								<textarea  id="XLabelsFormatter" value=""  class="textbox" placeHolder="return this.value;"></textarea>
							</li>
						</ul>
					</li>
				</ul>
			</div>
			<div style="float: left; width: 400px; padding:10px;">
				<span class="subTitle">Y축 설정</span>
				<ul class="ulTable" >
					<li class="liRow">
						<ul>
							<li class="liCellTitle" title="Y축 타이틀">Y 축 타이틀 설정 : </li>
							<li class="liCellContent">
								<input type="textarea" id="Ytitle" value="" size="30" class="inputbox" placeHolder="Y축 타이틀을 입력하세요."/>
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="Y축 타이틀 회전">Y 축 타이틀 회전 : </li>
							<li class="liCellContent">
								<input type="textarea" id="YTitleRotation" value="" size="10" class="inputbox" placeHolder="MAX 360"/>°
							</li>
						</ul>
						<ul style="height:10px"></ul>
						<ul>
							<li class="liCellTitle" title="Y축 선의 굵기">선의 굵기 : </li>
							<li class="liCellContent">
								<input type="textarea" id="YLineWidth"  size="10" class="inputbox" placeHolder="숫자입력"/> px
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="Y축 선의  색상">선의 색상 : </li>
							<li class="liCellContent">
								<input type="textarea" id="YLineColor" size="10" class="inputbox" placeHolder="#000000"/>
							</li>
						</ul>
						<ul style="height:10px"></ul>

						<ul style="height:10px"></ul>
						<ul>
							<li class="liCellTitle" title="Y축 내부 선 굵기">내부 선 굵기 : </li>
							<li class="liCellContent">
								<input type="textarea" id="YGridLineWidth" value="" size="10" class="inputbox" placeHolder="숫자입력"/> px
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="Y축 내부 선 색상">내부 선 색상 : </li>
							<li class="liCellContent">
								<input type="textarea" id="YGridLineColor" value="" size="10" class="inputbox" placeHolder="#DEDEDE"/>
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="Y축 내부 선 모양">내부 선 모양 : </li>
							<li class="liCellContent">
								<select id="YGridLineDashStyle" class="selectbox" style="width:150px;">
									<option value="solid" selected>Solid</option>
									<option value="shortdash">ShortDash</option>
									<option value="dot">Dot</option>
								</select>
							</li>
						</ul>
						<ul style="height:10px"></ul>
						<ul>
							<li class="liCellTitle" title="Y축 레이블 사용 여부">레이블 사용 여부 </li>
							<li class="liCellContent">
								<input class="checkbox" type="checkbox" checked id="YLabels" />
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="Y축 레이블 회전">Y축 레이블 회전 : </li>
							<li class="liCellContent">
								<input type="text" id="YLabelsRotation" value="" size="10" class="inputbox" placeHolder="MAX 360"/>°
							</li>
						</ul>

						<ul>
							<li class="liCellTitle" title="Y축 레이블 간격">레이블 간격 : </li>
							<li class="liCellContent">
								<input type="text" id="YTickInterval" value="" size="10" class="inputbox" placeHolder="숫자입력"/>
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="Y축 레이블 포멧">레이블 포멧 설정 : </li>
							<li class="liCellContent">
								<textarea  id="YLabelsFormatter" value=""  class="textbox" placeHolder="return this.value;"></textarea>
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="Y축 최대값">최대값 : </li>
							<li class="liCellContent">
								<input type="text" id="YMax" value="" size="10" class="inputbox" placeHolder="숫자입력"/>
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="Y축 최소값">최소값 : </li>
							<li class="liCellContent">
								<input type="text" id="YMin" value="" size="10" class="inputbox" placeHolder="숫자입력"/>
							</li>
						</ul>
						<ul style="height:10px"></ul>

						<ul>
							<li class="liCellTitle" title="세컨 Y축 사용">오른쪽 Y축 사용</li>
							<li class="liCellContent">
								<input class="checkbox" type="checkbox"  id="YSecond" />
							</li>
						</ul>
					</li>
				</ul>
			</div>
		</ul>
	</fieldset>
	<div style="height:5px"></div>
	<fieldset class="controlFieldSet">
		<legend class="fieldSetTitle">
			툴팁 설정
		</legend>
		<ul id="ulTooltip" class="ulTable" style="display:none">
			<li class="liRow">
				<ul>
					<li class="liRow">
						<ul>
							<li class="liCellTitle" title="툴팁">툴팁 사용 여부 설정 :</li>
							<li class="liCellContent">
								<input class="checkbox" type="checkbox" id="tooltipEnabled" checked/>
							</li>
						</ul>

						<ul>
							<li class="liCellTitle" title="툴팁값 공유">x축 포인트별 단일 툴팁 사용 :</li>
							<li class="liCellContent">
								<input class="checkbox" type="checkbox" id="tooltipShared" />
							</li>
						</ul>

						<ul>
							<li class="liCellTitle" title="툴팁 윤곽선 굵기">툴팁 윤곽선 굵기</li>
							<li class="liCellContent">
								<input type="text" id="tooltipBorderWidth" value="" size="10" class="inputbox" placeHolder="숫자입력"/>
							</li>
						</ul>


						<ul>
							<li class="liCellTitle" title="툴팁 포멧">툴팁 포멧</li>
							<li class="liCellContent">
								<textarea  id="tooltipFormatter"  title="사용 가능한 HTML 테그:&#10;<b>, <strong>, <i>, <em>, <br/>, <span>&#10;&#10;사용가능한 예약어:&#10;this.percentage (개별값) / this.points[i].percentage (포인트별 공유값)&#10; 누적차트나 파이차트에서만 사용. 전체 대비 퍼센테이지.&#10;this.series (개별값) / this.points[i].series (포인트별 공유값)&#10;범례에 표기되는 시리즈별 이름. this.series.name.&#10;this.total (개별값) / this.points[i].total (포인트별 공유값)&#10;누적차트에서만 사용가능. x축 포인트별 토탈 값&#10;this.x&#10;x축 레이블 값&#10;this.y (개별값) / this.points[i].y (포인트별 공유값)&#10;y축  값" value=""  class="textbox" style="width:300px;height:200px" placeHolder="return  this.x +  'is <b>' + this.y + '</b>';"></textarea>
							</li>
						</ul>
					</li>
				</ul>
			</li>
		</ul>
	</fieldset>
	<div style="height:5px"></div>
	<fieldset class="controlFieldSet">
		<legend class="fieldSetTitle">
			범례 설정
		</legend>
		<ul id="ulLegend" class="ulTable" style="display:none">
			<li class="liRow">
				<ul>
					<li class="liRow">
						<ul>
							<li class="liCellTitle" title="범례 사용여부">범례 사용 여부 설정 : </li>
							<li class="liCellContent">
								<input class="checkbox" type="checkbox" checked id="LegendEnabled" />
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="범례 타이틀">범례 타이틀 : </li>
							<li class="liCellContent">
								<input class="inputbox" size="30" id="LegendTitle" placeholder="타이틀"/>
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="범례 레이아웃">범례 레이아웃 설정 : </li>
							<li class="liCellContent">
								<select id="LegendLayout" class="selectbox" style="width:150px;">
									<option value="horizontal" selected>가로</option>
									<option value="vertical">세로</option>
								</select>
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="범례가로위치">범례 가로위치 설정 : </li>
							<li class="liCellContent">
								<select id="LegendAlign" class="selectbox" style="width:150px;">
									<option value="center" selected>center</option>
									<option value="left">left</option>
									<option value="right">right</option>
								</select>
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="범례세로위치">범례 상하위치 설정 : </li>
							<li class="liCellContent">
								<select id="LegendVerticalAlign" class="selectbox" style="width:150px;">
									<option value="top">top</option>
									<option value="middle">middle</option>
									<option value="bottom" selected>bottom</option>
								</select>
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="범례 플로팅 여부">범례 플로팅 여부 : </li>
							<li class="liCellContent">
								<input class="checkbox" type="checkbox" id="LegendFloating" />
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="범례 외곽선 두께">범례 외곽선 두께 : </li>
							<li class="liCellContent">
								<input type="text" id="LegendBorderWidth" value="1" size="10" class="inputbox" placeHolder="숫자입력"/>
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="범례 외곽선 Radius">범례 외곽선 Radius : </li>
							<li class="liCellContent">
								<input type="text" id="LegendRadius" value="5" size="10" class="inputbox" placeHolder="숫자입력"/>
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="범례 외곽선 Radius">범례 외곽선 색상 : </li>
							<li class="liCellContent">
								<input type="text" id="LegendBorderColor" value="" size="10" class="inputbox" placeHolder="#6423AE"/>
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="항목 역순">항목 역순 : </li>
							<li class="liCellContent">
								<input class="checkbox" type="checkbox" id="LegendReversed" />
							</li>
						</ul>
					</li>
				</ul>
			</li>
		</ul>
	</fieldset>

	<div style="height:5px"></div>
	<fieldset class="controlFieldSet">
		<legend class="fieldSetTitle">
			기타 설정
		</legend>
		<ul id="ulLegend" class="ulTable" style="display:none">
			<li class="liRow">
				<ul>
					<li class="liRow">
						<ul>
							<li class="liCellTitle" title="데이터 레이블 표시">데이타 레이블 표시 : </li>
							<li class="liCellContent">
								<input class="checkbox" type="checkbox" checked id="DataLabel"/>
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="데이터 레이블 표시">데이타 레이블 정렬 : </li>
							<li class="liCellContent">
								<select id="DataLabelAlign" class="selectbox" style="width:150px;">
									<option value="center" selected>center</option>
									<option value="left">left</option>
									<option value="right">right</option>
								</select>
							</li>
						</ul>
						<ul>
							<li class="liCellTitle" title="시리즈별 색상 설정">시리즈 별 색상 : </li>
							<li class="liCellContent_w">
								<input type="text" id="SeriesColor1" name="SeriesColor" value="" size="10" class="inputbox" placeHolder="#fd9c3c"/>,
								<input type="text" id="SeriesColor2" name="SeriesColor" value="" size="10" class="inputbox" placeHolder="#e5404c"/>,
								<input type="text" id="SeriesColor3" name="SeriesColor" value="" size="10" class="inputbox" placeHolder="#f6c8ba"/>,
								<input type="text" id="SeriesColor4" name="SeriesColor" value="" size="10" class="inputbox" placeHolder="#b7b0b5"/>,
								<input type="text" id="SeriesColor5" name="SeriesColor" value="" size="10" class="inputbox" placeHolder="#2ea4a8"/>,
								<input type="text" id="SeriesColor6" name="SeriesColor" value="" size="10" class="inputbox" placeHolder="#47586f"/>,
								<input type="text" id="SeriesColor7" name="SeriesColor" value="" size="10" class="inputbox" placeHolder="#adab6e"/>,
								<input type="text" id="SeriesColor8" name="SeriesColor" value="" size="10" class="inputbox" placeHolder="#c9a9c3"/>
							</li>
						</ul>

						<ul>
							<li class="liCellTitle" title="막대차트 사용시 시리즈 색상과 무관하게 포인트별로 다른 색상이 보여지게 끔 설정">포인트별 색상을 다르게<br>(막대차트에서만 사용가능) : </li>
							<li class="liCellContent">
								<input class="checkbox" type="checkbox" id="ColorByPoint"/>
							</li>
						</ul>


						<ul>
							<li class="liCellTitle" title="애니메이션 효과">애니메이션 사용 : </li>
							<li class="liCellContent">
								<input class="checkbox" type="checkbox" checked id="animation"/>
							</li>
						</ul>

						<ul>
							<li class="liCellTitle" title="확대기능 사용여부">확대 기능 사용 : </li>
							<li class="liCellContent">
								<select id="useZoom" class="selectbox" style="width:150px;">
									<option value="" selected>-사용안함-</option>
									<option value="x">x축</option>
									<option value="y">y축</option>
									<option value="xy">xy축</option>
								</select>
							</li>
						</ul>

					</li>
				</ul>
			</li>
		</ul>
	</fieldset>

	<div style="width:100%;height:5px"></div>
	<!-- InitHeaders 영역 -->
	<table class="ib_column2">
		<tr>
			<th class="tit" title="">타입</th>
			<td class="r20">
				<select id="charttype" class="selectbox" style="width:150px;">
					<option value="line" selected>꺽은선(line) 차트</option>
					<option value="area">영역(Area) 차트</option>
					<option value="spline">부드러운선(Spline) 차트</option>
					<option value="scatter">산점(Scatter) 차트</option>
					<option value="column">막대(Column) 차트</option>
					<option value="bar">가로막대(Bar) 차트</option>
					<option value="pie">파이(pie) 차트</option>

				</select>
			</td>
			<td class="r20">
				<a href="javascript:doAction('show');" class="f2_btn_white btn_sheet" style="width:80px">1. 차트 생성</a>
				<a href="javascript:doAction('make')" class="f2_btn_white btn_sheet">2. 소스 생성</a>
			</td>
		</tr>
	</table>
	<div style="width:100%;height:5px"></div>
	<p class="subtit_sheet">차트 생성</p>
	<div id="myChart"></div>
</div>
</div>
<!--main_content-->
<div id="dialog" title="IBChart 코드 생성" style="display:none">
	<textarea id="gcodetxt" style="width:100%;height:100%;"></textarea>
</div>
<br><br>


</body>
</html>